﻿// Listing 9-9

public class BubbleSortAlgorithm
{
   // Uwaga: To nie jest kompletny program.
   //
   // Metoda bubbleSort korzysta z algorytmu sortowania bąbelkowego
   // w celu posortowania tablicy typu int.
   // Zwróć uwagę na poniższe:
   // (1) Nie musimy przekazywać funkcji wielkości tablicy, ponieważ
   //     w języku Java tablice mają pole length.
   // (2) Nie mamy też osobnej metody podmieniającej elementy.
   //     Wynika to z faktu, że język Java nie pozwala na przekazywanie parametrów
   //     przez referencję. Podmiana wykonywana jest zatem w ramach metody.

   public static void bubbleSort(int[] array)
   {
      int maxElement;  // Wyznacza ostatni element do porównania
      int index;       // Indeks elementu do porównania
      int temp;        // Używana podczas podmiany elementów

      // Przy każdym obiegu przez tablicę, zewnętrzna pętla 
      // umieszcza w zmiennej maxElement indeks ostatniego
      // elementu do porównania. Początkowo w zmiennej maxElement
      // znajduje się indeks ostatniego elementu tablicy.
      // Przy każdej iteracji jest on dekrementowany.
      for (maxElement = array.length − 1; maxElement >= 0; maxElement--)
      {
         // Wewnętrzna pętla iteruje po tablicy i porównuje każdy 
         // element z jego sąsiadem. Do takich porównań używane są
         // elementy o indeksach od 0 do maxElement. Jeżeli porównywane
         // elementy mają niewłaściwą kolejność, to są zamieniane.
         for (index = 0; index <= maxElement − 1; index++)
         {
            // Porównanie elementu z jego sąsiadem.
            if (array[index] > array[index + 1])
            {
               // Zamiana dwóch elementów.
               temp = array[index];
               array[index] = array[index + 1];
               array[index + 1] = temp;
            }
         }
      }
   }
}
